/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.process.ospf.impl;

import com.cisco.pt.EncodedBuffer;
import com.cisco.pt.IPAddress;
import com.cisco.pt.ipc.enums.PtmpTypeValue;
import com.cisco.pt.ipc.sim.pdu.impl.OSPFLSAImpl;
import com.cisco.pt.ipc.sim.process.ospf.OSPFNetworkLSA;
import com.cisco.pt.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSPFNetworkLSAImpl
extends OSPFLSAImpl
implements OSPFNetworkLSA {
    protected IPAddress mask;
    protected List<IPAddress> routers;

    public OSPFNetworkLSAImpl() {
        this.fieldNames.add("OSPFNetworkLSAImpl_mask");
        this.fieldNames.add("OSPFNetworkLSAImpl_routers");
        this.signalType = "OspfNetworkLSA";
    }

    @Override
    public IPAddress getMask() {
        return this.mask;
    }

    @Override
    public void setMask(IPAddress mask) {
        this.mask = mask;
    }

    @Override
    public List<IPAddress> getRouters() {
        return this.routers;
    }

    @Override
    public void setRouters(List<IPAddress> routers) {
        this.routers = routers;
    }

    @Override
    public PtmpTypeValue getFieldType(String fieldName) {
        if (fieldName.equals("OSPFNetworkLSAImpl_mask")) {
            return PtmpTypeValue.IP_ADDRESS;
        }
        if (fieldName.equals("OSPFNetworkLSAImpl_routers")) {
            return PtmpTypeValue.DATA;
        }
        return super.getFieldType(fieldName);
    }

    private void populateFieldTable() {
        this.fieldTable.add(new Pair<String, IPAddress>("OSPFNetworkLSAImpl_mask", this.mask));
        this.fieldTable.add(new Pair<String, List<IPAddress>>("OSPFNetworkLSAImpl_routers", this.routers));
    }

    @Override
    public void read(EncodedBuffer buffer) {
        super.read(buffer);
        this.mask = this.readIPAddress(buffer);
        List<Object> tempList1 = this.readVector(buffer);
        this.routers = new ArrayList<IPAddress>();
        for (Object o : tempList1) {
            this.routers.add((IPAddress)o);
        }
        this.populateFieldTable();
    }

    @Override
    public void pduRead(EncodedBuffer buffer) {
        super.pduRead(buffer);
        this.mask = this.pduReadIPAddress(buffer);
        List<Object> tempList1 = this.pduReadVector(buffer, (byte)10);
        this.routers = new ArrayList<IPAddress>();
        for (Object o : tempList1) {
            this.routers.add((IPAddress)o);
        }
        this.populateFieldTable();
    }

    @Override
    public List<String> getOrderedFieldNames() {
        return Collections.unmodifiableList(this.fieldNames);
    }

    @Override
    public void encodeTypeAndPayload(EncodedBuffer buffer) {
        super.encodeTypeAndPayload(buffer);
        buffer.putIPAddress(this.mask);
        buffer.putInt(this.routers.size());
        for (IPAddress item : this.routers) {
            buffer.putIPAddress(item);
        }
    }
}

